# -*- coding: utf-8 -*-

from flectra import models


class AccountMoveLine(models.Model):
    _inherit = 'account.move.line'

    def _compute_analytic_distribution(self):
        # when a project creates an aml, it adds an analytic account to it. the following filter is to save this
        # analytic account from being overridden by analytic default rules and lack thereof
        project_amls = self.filtered(lambda aml: aml.analytic_distribution and any(aml.sale_line_ids.project_id))
        super(AccountMoveLine, self - project_amls)._compute_analytic_distribution()
        project_id = self.env.context.get('project_id')
        if project_id:
            analytic_account = self.env['project.project'].browse(project_id).analytic_account_id
            for line in project_amls:
                line.analytic_distribution = line.analytic_distribution or {analytic_account.id: 100}
