# -*- coding: utf-8 -*-
# Part of Flectra. See LICENSE file for full copyright and licensing details.


from flectra import models


class StockRule(models.Model):
    _inherit = 'stock.rule'

    def _get_stock_move_values(self, product_id, product_qty, product_uom, location_id, name, origin, company_id, values):
        move_values = super()._get_stock_move_values(product_id, product_qty, product_uom, location_id, name, origin, company_id, values)
        if values.get('product_description_variants') and values.get('group_id') and values['group_id'].pos_order_id:
            move_values['description_picking'] = values['product_description_variants']
        return move_values
